package gov.va.med.mhv.mrp.web.converter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.mrp.common.dto.MyGoalDTO;
import gov.va.med.mhv.mrp.web.model.MyGoal;

@Component
public class MyGoalListConverter implements Converter<List<MyGoalDTO>, List<MyGoal>>, Serializable {
	private static final long serialVersionUID = 1L;

	@Autowired
	private MyGoalConverter myGoalConverter;

	@Override
	public List<MyGoal> convert(List<MyGoalDTO> dtoList) {
		List<MyGoal> modelList = new ArrayList<MyGoal>();

		if (dtoList != null) {
			for (MyGoalDTO dto : dtoList) {
				MyGoal myGoal = myGoalConverter.convert(dto);
				modelList.add(myGoal);
			}
		}

		return modelList;
	}

}
